//package globalExamples;

import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmValueExpression;

import java.util.List;

/**
 * Complete code for Example 7-7, Sorting Products Hierarchically By Color,
 * in Chapter 7, Making Queries Using Source Objects, the Oracle OLAP 
 * Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 */
public class SortingHierarchicallyByAttribute 
{
  public SortingHierarchicallyByAttribute()
  {
  }

  public void run(String[] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();
    
    context.println("\nExample 7-7, Sorting Products Hierarchically By Color");
    
    // Get the PRODUCT dimension.
    MdmPrimaryDimension mdmProdDim = 
                               context.getMdmPrimaryDimensionByName("PRODUCT");
    
    // Create a color attribute for the dimension and get the Source for it.
    Source prodColorAttr = createColorAttribute(context, dp, mdmProdDim);

    // Get the default hierarchy of the dimension and the parent attribute
    // of the hierarchy.
    MdmHierarchy mdmProdRollup = mdmProdDim.getDefaultHierarchy();
    MdmAttribute mdmProdParentAttr = mdmProdRollup.getParentAttribute();
        
    // Get the Source objects for the metadata objects.
    StringSource prodDim = (StringSource) mdmProdDim.getSource(); 
    StringSource prodRollup = (StringSource) mdmProdRollup.getSource();
    Source prodParent = mdmProdParentAttr.getSource();
    
   // Sort products hierarchically, parents first, in ascending order
   // without using the color attribute.
   Source result1 = 
               prodRollup.recursiveJoin(prodDim.value(),
                                        prodRollup.getDataType(),
                                        prodParent,
                                        Source.COMPARISON_RULE_ASCENDING);
   
   // Sort products hierarchically, parents first, in ascending order
   // by color attribute value with null values first.
   // Nulls first is the default, so this should this should produce
   // the same results as COMPARISON_RULE_ASCENDING.
   Source sortedHierNullsFirst = 
            prodRollup.recursiveJoin(prodColorAttr,
                                  prodColorAttr.getDataType(),
                                  prodParent,
                                  Source.COMPARISON_RULE_ASCENDING_NULLS_FIRST);
  Source result2 = prodColorAttr.join(sortedHierNullsFirst);

   // Sort all products hierarchically, parents first, in ascending order
   // by color attribute value with null values first.
   Source sortedHierNullsLast = 
            prodRollup.recursiveJoin(prodColorAttr,
                                  prodColorAttr.getDataType(),
                                  prodParent,
                                  Source.COMPARISON_RULE_DESCENDING_NULLS_FIRST);
   Source result3 = prodColorAttr.join(sortedHierNullsLast); 

   context.commit();

   context.println("\nresult1, using COMPARISON_RULE_ASCENDING, " +
                   "without color attribute:");
   context.displayResult(result1);
   
   context.println("\nresult2, using COMPARISON_RULE_ASCENDING_NULLS_FIRST:");
   context.displayResult(result2);

   context.println("\nresult3, using COMPARISON_RULE_DESCENDING_NULLS_FIRST:");
   context.displayResult(result3); 
  }

  private Source createColorAttribute(Context10g context,
                                      DataProvider dp,
                                      MdmPrimaryDimension mdmProdDim) 
  {
    // Get the FundamentalMetadataProvider and the String data type object.
    FundamentalMetadataProvider fdp = 
                                   context.dp.getFundamentalMetadataProvider();
    FundamentalMetadataObject fmoSstringDT = fdp.getStringDataType();

    // Create a String for a SQL expression that assigns color values to
    // products except for a few to generate some null values for items.
    String sqlExp = "(case when item_id in " +
                    "(15, 19, 22, 24, 27, 33, 35, 46, 48) " + 
                    "then 'Black' " +
                    "when item_id in (13, 16) then 'Silver' " +
                    "when item_id in (17, 20, 23, 32, 36, 37, 47)" + 
                    " then 'Beige' " +
                    "when item_id in (25, 26, 31) then 'Green' " +
                    "when item_id in (28, 39) then 'Red' " +
                    "when item_id in (29) then 'Orange' " +
                    "when item_id in (40, 41, 42, 44, 45) then 'Blue' " +
                    "else null end)";

    // Get the MtmCustomObjectFactory and create a custom expression with the
    // SQL statement.
    MtmCustomObjectFactory mtmCustObjFactory = 
                                       context.mp.getMtmCustomObjectFactory();
    MtmValueExpression expression = (MtmValueExpression)
       mtmCustObjFactory.createCustomExpression(sqlExp, fmoSstringDT);
       
    // Get the MdmCustomObjectFactory and create a custom attribute with the
    // custom expression.
    MdmCustomObjectFactory mdmCustObjFactory = 
                                        context.mp.getMdmCustomObjectFactory();
    MdmAttribute mdmProdColorAttr = 
          mdmCustObjFactory.createStringAttribute("ProductColor",
                                                   mdmProdDim, 
                                                   expression);
                                                   
    // Get the Source for the custom attribute and return it.
    return mdmProdColorAttr.getSource();
  }

  public static void main(String[] args)
  {
    new SortingHierarchicallyByAttribute().run(args);
  }
}
